<?php
/**
 # index.php
 #
 # Frontend for Sudoku App
 #
 # @author Joachim Schmidt - joachim.schmidt@jschmidt-systemberatung.de
 # @copyright Copyright (C) 2014 Joachim Schmidt. All rights reserved.
 # @license	 http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 #
 # change activity:
 #                changed code for html5 standards
*/
// @formatter:off

    $settings = parse_ini_file ( "sudoku.ini", true );
    $notes =  parse_ini_file ($settings['notes_ini'], true);
    $valid_languages = $settings['languages'];
     
    $lang = "en";
    if (isset ($_REQUEST['lang']))
    {
      $lang = $_REQUEST['lang'];
      if (strpos($valid_languages, $lang) === false)
        $lang = "en";
    }
    $text = $settings[$lang];
    $notes = $notes[$lang];
    
    $tmp = explode("/index.php", $_SERVER['PHP_SELF']);
    $base = $tmp[0];
    $url = $base . "/sudoku_ajax.php";
    
    if (isset ( $_REQUEST ['sudoku'] ) && is_numeric( $_REQUEST ['sudoku'] ))
	   $parm = "&amp;sudoku=" . intval ( $_REQUEST ['sudoku'] );
	else
	   $parm = "&amp;sudoku=noid";
	   
	if (isset ( $_REQUEST ['level'] ) && is_numeric( $_REQUEST ['level'] ))
	   $parm .= "&amp;level=" . intval ( $_REQUEST ['level'] );
 
?>
<!DOCTYPE html>
<html lang="<?php echo $lang; ?>">
<head>
<meta charset="utf-8"/>
<meta name="designer" content="Joachim Schmidt - http://www.jschmidt-systemberatung.de" />
<meta name="description" content="Sudoku Puzzles Web Application" />
<title><?php echo $text['title']; ?></title>
<link href="<?php echo $base; ?>/css/style.css" rel="stylesheet" type="text/css" />
<script src="<?php echo $base; ?>/js/jquery.min.js" type="text/javascript" ></script>
<script src="<?php echo $base; ?>/js/sudoku.min.js" type="text/javascript"></script>
<style type="text/css" media="print">.no-print { display: none; }</style>
</head>

<body style="background-color: #f0f0f0; max-width: 800px; margin: 30px;" onload="getPuzzle('<?php echo $url . "','" .$parm; ?>')">
<div id="language" style="display: none;"><?php echo $lang; ?></div>
<h2><?php echo $text['title']; ?></h2>
<div id="sudoku-container" class="sudoku-container">
<div class="bubble">
 <div id="sudokuid" class="rectangle"><h2>Sudoku - </h2></div>
 <div class="triangle-l"></div>
 <div class="triangle-r"></div>
<div class="sudoku-info">

<div id="sudoku" class="center">
<div id='msgbox_content' style='display: none'><?php echo $text['msgbox_content']; ?></div>

<?php

	$html = "\n<table class='sudoku'>";
	$count = 0;
	$check = "onkeyup='checkValue($count, true, true)'";
	for ($x = 0; $x < 9; $x++)
	{
	    $html .= "\n<tr>";
		for ($y = 0; $y < 9; $y++)
		{
			$class = "cell";
			if ($y == 2 || $y == 5)
			$class = "cell cell-right";
				
			if ($x == 2 || $x == 5)
			$class = "cell cell-bottom";
		
			if (($y == 2 && $x == 2) || ($y == 2 && $x == 5))
			$class = "cell cell-both";
				
			if (($y == 5 && $x == 2) || ($y == 5 && $x == 5))
			$class = "cell cell-both";
	
			$check = "onkeyup='checkValue($count, true, true)'";
	
					$html .= "\n<td class='" . $class . "'>";
							$html .= "\n <div id='candidates" . $count . "' class='overlay'></div>";
			$html .= "\n <input type='text' id='i" . $count . "' name='i" . $count . "' " .
			"value='' size='1' maxlength='1' class='cell' $check />\r\n";
			$html .= "</td>";
			$count ++;
		}
		$html .= "</tr>";
	}
	$html .= "\n</table>";
	echo $html;
?>
<br />

<form id="form" class="sudoku-form" name="form" action="none">
<input type="hidden" name="sudoku" value="" />
<input class="sudokubutton" id="button1"  type="button" value="<?php echo $text['new_sudoku']; ?>" onclick="getPuzzle('<?php echo $url . "','null"; ?>')" />
<input class="sudokubutton" id="button2"  type="button" value="<?php echo $text['solution']; ?>" onclick="showSolution()" />
<input class="sudokubutton" id="button3"  type="button" value="<?php echo $text['print']; ?>" onclick="window.print()" />
<input type="checkbox" id="help" name="help" value="0" onclick="checkValues()" />&nbsp;<?php echo $text['help']; ?>
<input type="checkbox" id="check" name="check" value="1" checked="checked" onclick="checkValues()" />&nbsp;<?php echo $text['check']; ?>
<br />
<br /><b style="padding-left: 40px;">Level:</b>&nbsp;
<input type="radio" id="level0" name="level" value="0" checked="checked" /><?php echo $text['level0']; ?>
<input type="radio" id="level1" name="level" value="1" />&nbsp;<?php echo $text['level1']; ?>
<input type="radio" id="level2" name="level" value="2" />&nbsp;<?php echo $text['level2']; ?>
</form>
<div id="messages" class="sudoku-messages">&nbsp;</div>
</div>
</div>
</div>
<div id="notes" class="no-print">
<?php echo $notes['notes']; ?>
</div>
</div>

</body>
</html>